document.addEventListener('DOMContentLoaded', () => {
    const select = document.getElementById('fontselect');

    fetch('https://api.studioaster.net/xfiltertool/api/fontapi.php')
        .then(res => res.json())
        .then(data => {
            data.forEach(item => {
                const option = document.createElement('option');
                option.value = item.value;
                option.textContent = item.font;
                select.appendChild(option);
            });
            const ev = new Event('fontOptionsReady');
            select.dispatchEvent(ev);
        })
        .catch(err => {
            console.error(err);
        });
});
