let injectedLink1 = null;
let injectedLink2 = null;

function insertCss1() {
  if (injectedLink1) return;
  injectedLink1 = document.createElement('link');
  injectedLink1.rel = 'stylesheet';
  injectedLink1.href = 'https://api.studioaster.net/xfiltertool/style/a00.css';
  document.head.appendChild(injectedLink1);
}

function removeCss1() {
  if (!injectedLink1) return;
  injectedLink1.remove();
  injectedLink1 = null;
}

function insertCss2() {
  if (injectedLink2) return;
  injectedLink2 = document.createElement('link');
  injectedLink2.rel = 'stylesheet';
  injectedLink2.href = 'https://api.studioaster.net/xfiltertool/style/a01.css';
  document.head.appendChild(injectedLink2);
}

function removeCss2() {
  if (!injectedLink2) return;
  injectedLink2.remove();
  injectedLink2 = null;
}

function applyMode(mode) {
  if (mode === 'red') {
    insertCss1();
    removeCss2();
  } else if (mode === 'none') {
    insertCss2();
    removeCss1();
  } else {
    removeCss1();
    removeCss2();
  }
}

chrome.storage.sync.get(['blockMode'], (result) => {
  applyMode(result.blockMode);
});

chrome.storage.onChanged.addListener((changes) => {
  if (changes.blockMode) {
    applyMode(changes.blockMode.newValue);
  }
});
