console.log("X filter tool loaded");

const isPopup =
    location.protocol === 'chrome-extension:' &&
    location.pathname.includes('popup');

const applySavedFont = () => {
    if (isPopup) return;

    chrome.storage.local.get(['selectedFont'], (res) => {
        const val = res.selectedFont;
        const id = 'custom-font-style';
        const old = document.getElementById(id);

        if (!val || val === 'default') {
            if (old) old.remove();
            return;
        }

        const name = val.replace(/\+/g, ' ');
        const style = old || document.createElement('style');
        style.id = id;
        style.textContent = `
            * , body , * * , .r-1tl8opc {
                font-family: "${name}" !important;
            }
        `;
        if (!old) (document.head || document.documentElement).appendChild(style);
    });
};

applySavedFont();

if (!isPopup) {
    const observer = new MutationObserver(() => {
        if (!document.getElementById('custom-font-style')) {
            applySavedFont();
        }
    });
    observer.observe(document.documentElement, { childList: true, subtree: true });
}
chrome.storage.onChanged.addListener((changes, area) => {
    if (area === 'sync' && changes.selectedFont) {
        applySavedFont();
    }
});
